# Markdown 使用指南

Shear 支持丰富的 Markdown 功能，帮助您格式化剪贴板内容。以下是关于如何使用现有功能的指南。

## 1. 基础 Markdown

支持标准的 GitHub 风格 Markdown (GFM)。

*   **加粗**: `**加粗**` 或 `__加粗__`
*   **斜体**: `*斜体*` 或 `_斜体_`
*   **删除线**: `~~删除线~~`
*   **列表**:
    *   无序列表: `-` 或 `*`
    *   有序列表: `1.`
*   **链接**: `[链接文本](url)`
*   **图片**: `![替代文本](url)`
*   **引用**: `> 引用内容`
*   **水平分割线**: `---`

## 2. 代码块

我们使用 `highlight.js` 进行语法高亮，并采用 `github-dark` 主题。

### 基础代码块

```js
console.log("Hello, World!");
```

````markdown
```js
console.log("Hello, World!");
```
````

### 行号

在语言标识符后添加 `line-numbers` 即可显示行号。

````markdown
```js line-numbers
function add(a, b) {
  return a + b;
}
```
````

### 高亮行

使用 `lines=start-end` 来高亮特定行。

````markdown
```js line-numbers lines=2-3
function add(a, b) {
  // 这一行会被高亮
  return a + b;
}
```
````

## 3. 数学公式 / LaTeX

我们使用 KaTeX 支持数学表达式。

### 行内公式
用单个美元符号 `$` 包裹您的公式。

**示例:** $E = mc^2$

**语法:** `$E = mc^2$`

### 块级公式
用双美元符号 `$$` 包裹您的公式。

**示例:**
$$
\sum_{i=0}^n i^2 = \frac{(n^2+n)(2n+1)}{6}
$$

**语法:**
```latex
$$
\sum_{i=0}^n i^2 = \frac{(n^2+n)(2n+1)}{6}
$$
```

## 4. 提示块 (Callouts)

使用 `:::` 语法创建彩色的提示块。

**支持的类型:** `info` (信息), `success` (成功), `warning` (警告), `error` (错误)。

### 基础语法

```markdown
:::info
这是一个信息提示块。
:::
```

### 带标题

```markdown
:::warning[注意]
请小心操作！
:::
```

### 默认展开/折叠

提示块是可折叠的。添加 `{open}` 使其默认展开。

```markdown
:::success[完成]{open}
操作成功完成。
:::
```

## 5. 高级表格

我们的表格支持行合并和列合并。

*   在单元格中使用 `^` 与上方单元格合并 (Rowspan)。
*   在单元格中使用 `<` 与左侧单元格合并 (Colspan)。

**示例:**

```markdown
| 表头 1   | 表头 2   |
| :------- | :------- |
| 单元格 1 | 单元格 2 |
| ^        | 单元格 3 |
| 单元格 4 | <        |
```

*   第 2 行第 1 列与第 1 行第 1 列合并。
*   第 3 行第 2 列与第 3 行第 1 列合并。

## 6. 可爱风格表格 (Cute Tables)

如果想要更具风格化的表格外观，请将表格包裹在 `:::cute-table` 块中。

```markdown
:::cute-table
| ID | 姓名  | 角色  |
| -- | ----- | ----- |
| 1  | Alice | 管理员 |
| 2  | Bob   | 用户  |
:::
```
